using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace SMAT_CE
{
    public partial class uc_DataInputD : ucBase
    {
        //public string _fileName;
        public static int intPage = 0;
        string path = "";
        public uc_DataInputD()
        {
            InitializeComponent();

            #region Language added by Yangwenwei
            if (LanguageOld.CurrentLanguage() == "Ch")
            {
                //Language.GetLanguagePath();
                Dictionary<string, string> dic = new Dictionary<string, string>();
                LanguageOld.SetDicFromXml(this, dic);
                LanguageOld.ChangeLanguage(dic, this);
            }
            #endregion
        }

        private void uc_DataInputD_Load(object sender, EventArgs e)
        {
            try
            {
                cboSpeciesFractionsPointD.Items.Add("point");
                cboSpeciesFractionsSpatialD.Items.Add("spatial field");
                cboSpeciesFractionsSpatialD.Items.Add("grad adj spatial field");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }

        }

        /// <summary>
        /// Initialize Control
        /// add by Devin
        /// 20190724
        /// </summary>
        public void InitializeControl()
        {
            if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD == null)
            {
                (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD = new DataInputD();
                rbtnSpeciesMonitorD.Checked = true;
                if (CommonClass.dicExampleConfiguration != null)
                {
                    CommonClass.speciesMonitorFile = CommonClass.dicExampleConfiguration["DailyPM"]["speciesMonitorDataFile"];
                    txtSpeciesMonitorFileD.Text = Path.GetFileName(CommonClass.speciesMonitorFile);
                    cboSpeciesFractionsPointD.SelectedIndex = 0;
                    cboSpeciesFractionsSpatialD.SelectedIndex = 0;
                    CommonClass.unofficialPMFile = CommonClass.dicExampleConfiguration["DailyPM"]["unofficialMonitorFile"];
                    txtUnofficialMonitorDataFileD.Text = Path.GetFileName(CommonClass.unofficialPMFile);
                    CommonClass.officialPMFile = CommonClass.dicExampleConfiguration["DailyPM"]["officialMonitorFile"];
                    txtOfficialMonitorDataFileD.Text = Path.GetFileName(CommonClass.officialPMFile);
                    rbtnDailyModelDataD.Checked = true;
                    CommonClass.baseModelFile = CommonClass.dicExampleConfiguration["DailyPM"]["baselineModelFile"];
                    txtBaselineFileD.Text = Path.GetFileName(CommonClass.baseModelFile);
                    CommonClass.futureModelFile = CommonClass.dicExampleConfiguration["DailyPM"]["forecastModelFile"];
                    txtForecastFileD.Text = Path.GetFileName(CommonClass.futureModelFile);
                }    
            }
            else
            {
                rbtnSpeciesMonitorD.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.doSpeciesMonitorDataFile;
                CommonClass.speciesMonitorFile = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.speciesMonitorDataFile;
                txtSpeciesMonitorFileD.Text = Path.GetFileName(CommonClass.speciesMonitorFile);
                rbtnSpeciesFractionD.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.doSpeciesFractionFile;
                cboSpeciesFractionsPointD.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.specFracModePoint;
                CommonClass.speciesFractionFilePoint = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.specFracPointFile;
                txtSpeciesFractionsFilePointD.Text = Path.GetFileName(CommonClass.speciesFractionFilePoint);
                cboSpeciesFractionsSpatialD.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.specFracModeSpatial;
                CommonClass.speciesFractionFileSpatial = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.specFracSpatialFile;
                txtSpeciesFractionsFileSpatialD.Text = Path.GetFileName(CommonClass.speciesFractionFileSpatial);
                CommonClass.unofficialPMFile = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.unofficialMonitorFile;
                txtUnofficialMonitorDataFileD.Text = Path.GetFileName(CommonClass.unofficialPMFile);
                CommonClass.officialPMFile = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.officialMonitorFile;
                txtOfficialMonitorDataFileD.Text = Path.GetFileName(CommonClass.officialPMFile);
                rbtnDailyModelDataD.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.doDailyModelDataInput;
                rbtnQuarterlyPeakModelDataD.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.doQuarterlyPeakModelDataInput;
                rbtnCMAQFileD.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.doInputfromCmaq;
                CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.baselineModelFile;
                txtBaselineFileD.Text = Path.GetFileName(CommonClass.baseModelFile);
                CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.forecastModelFile;
                txtForecastFileD.Text = Path.GetFileName(CommonClass.futureModelFile);
            }
        }

        private void btnOpenMonitorFileD_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !Directory.Exists(path))
                {
                    if (string.IsNullOrEmpty(CommonClass.speciesMonitorFile) || !Directory.Exists(Path.GetDirectoryName(CommonClass.speciesMonitorFile)))
                    {
                        openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                    }
                    else
                    {
                        openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.speciesMonitorFile);
                    }
                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = LanguageOld.Translate("Select file...");
                openfile.Filter = LanguageOld.Translate("CSV Files(*.csv)|*.csv");
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.speciesMonitorFile = openfile.FileName;
                    txtSpeciesMonitorFileD.Text = Path.GetFileName(CommonClass.speciesMonitorFile);
                    path = Path.GetDirectoryName(openfile.FileName);
                    openfile.RestoreDirectory = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnFractionPointD_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !Directory.Exists(path))
                {
                    if (string.IsNullOrEmpty(CommonClass.speciesFractionFilePoint) || !Directory.Exists(Path.GetDirectoryName(CommonClass.speciesFractionFilePoint)))
                    {
                        openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                    }
                    else
                    {
                        openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.speciesFractionFilePoint);
                    }
                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = LanguageOld.Translate("Select file...");
                // Application.StartupPath + @"\Data\SampleData";
                openfile.Filter = LanguageOld.Translate("CSV Files(*.csv)|*.csv");
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.speciesFractionFilePoint = openfile.FileName;
                    txtSpeciesFractionsFilePointD.Text = Path.GetFileName(CommonClass.speciesFractionFilePoint);
                    path = Path.GetDirectoryName(openfile.FileName);
                    openfile.RestoreDirectory = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnFractionSpatialD_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !Directory.Exists(path))
                {
                    if (string.IsNullOrEmpty(CommonClass.speciesFractionFileSpatial) || !Directory.Exists(Path.GetDirectoryName(CommonClass.speciesFractionFileSpatial)))
                    {
                        openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                    }
                    else
                    {
                        openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.speciesFractionFileSpatial);
                    }
                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = LanguageOld.Translate("Select file...");
                //Application.StartupPath + @"\Data\SampleData";
                openfile.Filter = LanguageOld.Translate("CSV Files(*.csv)|*.csv");
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.speciesFractionFileSpatial = openfile.FileName;
                    txtSpeciesFractionsFileSpatialD.Text = Path.GetFileName(CommonClass.speciesFractionFileSpatial);
                    path = Path.GetDirectoryName(openfile.FileName);
                    openfile.RestoreDirectory = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnUnofficialMonitorD_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !Directory.Exists(path))
                {
                    if (string.IsNullOrEmpty(CommonClass.unofficialPMFile) || !Directory.Exists(Path.GetDirectoryName(CommonClass.unofficialPMFile)))
                    {
                        openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                    }
                    else
                    {
                        openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.unofficialPMFile);
                    }
                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = LanguageOld.Translate("Select file...");
                //openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                openfile.Filter = LanguageOld.Translate("CSV Files(*.csv)|*.csv");
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.unofficialPMFile = openfile.FileName;
                    txtUnofficialMonitorDataFileD.Text = Path.GetFileName(CommonClass.unofficialPMFile);
                    path = Path.GetDirectoryName(openfile.FileName);
                    openfile.RestoreDirectory = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnOfficialMonitorD_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !Directory.Exists(path))
                {
                    if (string.IsNullOrEmpty(CommonClass.officialPMFile) || !Directory.Exists(Path.GetDirectoryName(CommonClass.officialPMFile)))
                    {
                        openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                    }
                    else
                    {
                        openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.officialPMFile);
                    }
                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = LanguageOld.Translate("Select file...");
                //openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                openfile.Filter = LanguageOld.Translate("CSV Files(*.csv)|*.csv");

                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.officialPMFile = openfile.FileName;
                    txtOfficialMonitorDataFileD.Text = Path.GetFileName(CommonClass.officialPMFile);
                    path = Path.GetDirectoryName(openfile.FileName);
                    openfile.RestoreDirectory = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnBaselineD_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !Directory.Exists(path))
                {
                    if (string.IsNullOrEmpty(CommonClass.baseModelFile) || !Directory.Exists(Path.GetDirectoryName(CommonClass.baseModelFile)))
                    {
                        openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                    }
                    else
                    {
                        openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.baseModelFile);
                    }
                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = LanguageOld.Translate("Select file...");
                //openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                string filter = "";
                if (rbtnCMAQFileD.Checked == true)
                {
                    filter = LanguageOld.Translate("All Files(*.*)|*.*");
                }
                else
                {
                    filter = LanguageOld.Translate("CSV Files(*.csv)|*.csv");
                }
                openfile.Filter = filter;

                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.baseModelFile = openfile.FileName;
                    txtBaselineFileD.Text = Path.GetFileName(CommonClass.baseModelFile);
                    path = Path.GetDirectoryName(openfile.FileName);
                    openfile.RestoreDirectory = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnForecastD_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !Directory.Exists(path))
                {
                    if (string.IsNullOrEmpty(CommonClass.futureModelFile) || !Directory.Exists(Path.GetDirectoryName(CommonClass.futureModelFile)))
                    {
                        openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                    }
                    else
                    {
                        openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.futureModelFile);
                    }
                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = LanguageOld.Translate("Select file...");
                //openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                string filter = "";
                if (rbtnCMAQFileD.Checked == true)
                {
                    filter = LanguageOld.Translate("All Files(*.*)|*.*");
                }
                else
                {
                    filter = LanguageOld.Translate("CSV Files(*.csv)|*.csv");
                }
                openfile.Filter = filter;
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.futureModelFile = openfile.FileName;
                    txtForecastFileD.Text = Path.GetFileName(CommonClass.futureModelFile);
                    path = Path.GetDirectoryName(openfile.FileName);
                    openfile.RestoreDirectory = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void rbtnSpeciesMonitorD_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (rbtnSpeciesMonitorD.Checked)
                {
                    txtSpeciesMonitorFileD.Enabled = true;
                    txtSpeciesMonitorFileD.BackColor = Color.White;
                    btnOpenMonitorFileD.Enabled = true;
                    cboSpeciesFractionsPointD.Enabled = false;
                    txtSpeciesFractionsFilePointD.Enabled = false;
                    txtSpeciesFractionsFilePointD.BackColor = Color.FromKnownColor(KnownColor.Control);
                    btnFractionPointD.Enabled = false;
                    cboSpeciesFractionsSpatialD.Enabled = false;
                    txtSpeciesFractionsFileSpatialD.Enabled = false;
                    txtSpeciesFractionsFileSpatialD.BackColor = Color.FromKnownColor(KnownColor.Control);
                    btnFractionSpatialD.Enabled = false;
                    txtUnofficialMonitorDataFileD.Enabled = true;
                    txtUnofficialMonitorDataFileD.BackColor = Color.White;
                    btnUnofficialMonitorD.Enabled = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void rbtnSpeciesFractionD_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD != null
                    && (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD.doNeighborFilePoint == true)
                {
                    MessageBox.Show(LanguageOld.Translate("Using species fractions file. Disable neighbor file creation."), LanguageOld.Translate("Tip"), MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
                if (rbtnSpeciesFractionD.Checked)
                {
                    txtSpeciesMonitorFileD.Enabled = false;
                    txtSpeciesMonitorFileD.BackColor = Color.FromKnownColor(KnownColor.Control);
                    btnOpenMonitorFileD.Enabled = false;
                    cboSpeciesFractionsPointD.Enabled = true;
                    txtSpeciesFractionsFilePointD.Enabled = true;
                    txtSpeciesFractionsFilePointD.BackColor = Color.White;
                    btnFractionPointD.Enabled = true;
                    cboSpeciesFractionsSpatialD.Enabled = false;
                    txtSpeciesFractionsFileSpatialD.Enabled = false;
                    txtSpeciesFractionsFileSpatialD.BackColor = Color.FromKnownColor(KnownColor.Control);
                    btnFractionSpatialD.Enabled = false;
                    txtUnofficialMonitorDataFileD.Enabled = false;
                    txtUnofficialMonitorDataFileD.BackColor = Color.FromKnownColor(KnownColor.Control);
                    btnUnofficialMonitorD.Enabled = false;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void rbtnDailyModelDataD_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (rbtnDailyModelDataD.Checked == true)
                {
                    CommonClass.baseModelFile = Application.StartupPath + @"\Data\SampleData\Model_data\SMAT.PM.Large.12.SE_US2.2011eh.camx.grid.csv";//PM_small_USA_12km_2011.csv";
                    CommonClass.futureModelFile = Application.StartupPath + @"\Data\SampleData\Model_data\SMAT.PM.Large.12.SE_US2.2017eh.camx.grid.csv";//PM_small_USA_12km_2018.csv";
                    txtBaselineFileD.Text = Path.GetFileName(CommonClass.baseModelFile);
                    txtForecastFileD.Text = Path.GetFileName(CommonClass.futureModelFile);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void rbtnQuarterlyPeakModelDataD_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (rbtnQuarterlyPeakModelDataD.Checked == true)
                {
                    txtBaselineFileD.Text = "";
                    txtForecastFileD.Text = "";
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void rbtnCMAQFileD_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (rbtnCMAQFileD.Checked == true)
                {
                    txtBaselineFileD.Text = "";
                    txtForecastFileD.Text = "";
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblSpeciesData_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_2_3_data_input.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblPMMonitorData_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_2_3_data_input.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblModelData_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_2_3_data_input.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }
    }
}
